#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze
import datetime
import os
import os.path
import re
import sys
import time
import shutil

import auto_rec
import auto_process
import chdb
import checker
import configreader
import epgdb
import rec10d
import recdb
import status
import tv2avi
import tv2mkv
import tv2mp4
import install
import recdblist
recpath = configreader.getpath('recpath')
movepath = configreader.getpath('move_destpath')
path = str(os.path.dirname(os.path.abspath(__file__))) + "/"
def task():
    """
    数分毎に実行されるタスク処理
    予定によって子プロセスを生成し処理する。
    """
    try:
        if rec10d.rec10db.select_installed_in_status()==0:
            install.install()
    except:
        install.install()
    recdb.delete_old("24")
    recdb.delete_old_auto_bayes("1")
    recdb.delete_old_auto_keyword("1")
    tasks = recdb.getnow("3")
    inum = recdb.countRecNow_minutes("10")
    recdblist.printutf8(u"rec10処理開始"+ datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S"))
    recdblist.printutf8(u"直近録画予約件数:" + str(inum) + u"BS/CS録画中件数:" + str(status.getBSCSRecording()) + u"TE録画中件数:" + str(status.getTERecording()) )
    encodenum=0
    b25num=0
    dnow=datetime.datetime.now()
    if dnow.minute%10<5:
        pid = os.fork()
        if pid != 0:
            ""
        else:
            for k in recdb.get_key():
                search_keyword(k)
            sys.exit()
    else:
        pid = os.fork()
        if pid!=0:
            ""
        else:
            time.sleep(10)
            auto_process.auto_check(recpath)
            sys.exit()
    update = chdb.update()
    if len(update) > 0:
        pid = os.fork()
        if pid != 0:
            ""
        else:
            i = 0
            for bctype in update:
                recnum = 0
                if bctype.find('te') > -1:
                    recnum = status.getTERecording() + recdb.countRecNow_minutes_TE("10")
                    recdblist.printutf8(u"放送種別:"+bctype + u"||該当チューナー実行中件数:" + str(status.getTERecording()) + u":直近予約件数:" + str(recdb.countRecNow_minutes_TE("10")))
                    recnum = int(configreader.getenv("te_max")) -recnum
                else:
                    recnum = status.getBSCSRecording() + recdb.countRecNow_minutes_BSCS("10")
                    recdblist.printutf8(u"放送種別:"+bctype + u"||該当チューナー実行中件数:" + str(status.getBSCSRecording()) + u":直近予約件数:" + str(recdb.countRecNow_minutes_BSCS("10")))
                    recnum = int(configreader.getenv("bscs_max")) -recnum
                if recnum >0 :
                    print update
                    rec10d.rec10db.update_status_by_bctype_epg_ch(bctype, "0")
                    epgdb.updatebc(bctype)
                    update = chdb.update()
                    i = i + 1
                if i > 0:
                    break
            sys.exit()
    for task in tasks:
        typetxt = task["type"]
        try:
            chtxt = task['chtxt']
        except:
            chtxt = ""
        try:
            title = task['title']
        except:
            title = ""
        try:
            btime = task['btime']
            bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
        except:
            btime = ""
            bt = datetime.datetime.strptime("2009-01-01 00:00:00", "%Y-%m-%d %H:%M:%S")
        try:
            etime = task['etime']
            et = datetime.datetime.strptime(etime, "%Y-%m-%d %H:%M:%S")
        except:
            etime = ""
            et = datetime.datetime.strptime("2009-01-01 00:00:00", "%Y-%m-%d %H:%M:%S")
        try:
            opt = task['opt']
        except:
            opt = ""
        tnow = datetime.datetime.now()
        dtt = bt-tnow
        dt = dtt.days * 24 * 60 * 60 + dtt.seconds
        if task["type"] == recdblist.REC_RESERVE:#"res,"+chtxt+","+title+","+btime+","+etime+","+opt
            pid = os.fork()
            if pid != 0:#親プロセスの場合
                ""
            else:#子プロセスの場合　アップデートを行って終了
                type_reserve(task["type"],chtxt,title,bt,et,opt)
                sys.exit()
        elif task["type"] == recdblist.REC_KEYWORD:#"key,"+chtxt+","+keyword+","+btime+","+deltatime+","+opt
            deltatime = task['deltatime']
            pid = os.fork()
            if pid != 0:#親プロセスの場合
                ""
            else:#子プロセスの場合　アップデートを行って終了
                type_keyword(task["type"],chtxt,title, bt, et, opt, deltatime)
                sys.exit()
        elif task["type"] == recdblist.REC_KEYWORD_EVERY_SOME_DAYS:#"keyevery,"+chtxt+","+keyword+","+btime+","+deltatime+","+opt+","+deltaday
            deltatime = task['deltatime']
            deltaday = task['deltaday']
            pid = os.fork()
            if pid != 0:#親プロセスの場合
                ""
            else:#子プロセスの場合　アップデートを行って終了
                type_keyword_every_day(task["type"],chtxt, title, bt, et, opt, deltatime, deltaday)
                sys.exit()
        elif task["type"] == recdblist.REC_FINAL_RESERVE:#"rec,"+chtxt+","+title+","+btime+","+etime+","+opt
            pid = os.fork()
            if pid != 0:#親プロセスの場合
                ""
            else:#子プロセスの場合　アップデートを行って終了
                type_final(task["type"],chtxt, title, bt, et, opt)
                sys.exit()
        elif task["type"] == recdblist.REC_TS_DECODE_QUE:
            b25num=b25num+1
            pid = os.fork()
            if pid != 0:#親プロセスの場合
                ""
            else:#子プロセスの場合　アップデートを行って終了
                time.sleep(5*b25num)
                type_decode_que(task["type"],chtxt, title, bt, et, opt)
                sys.exit()
        elif task["type"] == recdblist.REC_ENCODE_QUE:
            encodenum=encodenum+1
            pid = os.fork()
            if pid != 0:#親プロセスの場合
                ""
            else:#子プロセスの場合　アップデートを行って終了
                time.sleep(5*encodenum)
                type_encode_que(task["type"],chtxt, title, bt, et, opt)
                sys.exit()
        elif task["type"] == recdblist.REC_AVI_TO_MKV:
            if dt < 10 * 60:
                pid = os.fork()
                if pid > 0:#親プロセスの場合
                    ""
                else:
                    recdb.del_reckey(recdblist.REC_AVI_TO_MKV, title, chtxt, btime)
                    recdb.rec_reckey(recdblist.REC_CHANGING_CANTAINER, title, chtxt, btime, etime, opt)
                    #tv2mp4.avi2mp4(os.path.join(recpath,title+".avi"),os.path.join(recpath,title+".mkv"),opt)
                    tv2mkv.avi2mkv(os.path.join(recpath,title+".avi"),os.path.join(recpath,title+".mkv"),opt)
                    recdb.del_reckey(recdblist.REC_CHANGING_CANTAINER, title, chtxt, btime)
                    sys.exit()
        elif task["type"] == recdblist.REC_AVI_TO_MP4:
            if dt < 10 * 60:
                pid = os.fork()
                if pid > 0:#親プロセスの場合
                    ""
                else:
                    recdb.del_reckey(recdblist.REC_AVI_TO_MP4, title, chtxt, btime)
                    recdb.rec_reckey(recdblist.REC_CHANGING_CANTAINER, title, chtxt, btime, etime, opt)
                    tv2mp4.avi2mp4(os.path.join(recpath,title+".avi"),os.path.join(recpath,title+".mp4"),opt)
                    recdb.del_reckey(recdblist.REC_CHANGING_CANTAINER, title, chtxt, btime)
                    sys.exit()
        elif task["type"] == recdblist.REC_MKV_TO_MP4:
            if dt < 10 * 60:
                pid = os.fork()
                if pid > 0:#親プロセスの場合
                    ""
                else:
                    recdb.del_reckey(recdblist.REC_MKV_TO_MP4, title, chtxt, btime)
                    recdb.rec_reckey(recdblist.REC_CHANGING_CANTAINER, title, chtxt, btime, etime, opt)
                    tv2mp4.mkv2mp4(os.path.join(recpath,title+".mkv"),os.path.join(recpath,title+".mp4"))
                    recdb.del_reckey(recdblist.REC_CHANGING_CANTAINER, title, chtxt, btime)
                    sys.exit()
    sys.exit()
def search_keyword(key):
    tnow = datetime.datetime.now()
    nows =tnow.strftime("%Y-%m-%d %H:%M:%S")
    for k in key:
        recdatum = epgdb.searchtime_auto(k,nows, "144")
        for recdata in recdatum:
            if recdata[1] != "":
                chtxtt = recdata[0]
                titlet = recdata[1]
                btimet = recdata[2]
                etimet = recdata[3]
                btt = datetime.datetime.strptime(btimet, "%Y-%m-%d %H:%M:%S")
                ett = datetime.datetime.strptime(etimet, "%Y-%m-%d %H:%M:%S")
                btimet = btt.strftime("%Y-%m-%d %H:%M:%S")
                etimet = ett.strftime("%Y-%m-%d %H:%M:%S")
                if status.getSettings_auto_jbk()==1:
                    topt=status.getSettings_auto_opt()
                    try:
                        maxnum=0
                        if len(ch['ch'])>2:
                            maxnum=epgdb.count_schedule_timeline(btimet, etimet)[1]
                            maxnum=int(configreader.getenv("bscs_max"))-maxnum
                        else:
                            maxnum=epgdb.count_schedule_timeline(btimet, etimet)[0]
                            maxnum=int(configreader.getenv("te_max"))-maxnum
                        if maxnum>0:
                            topt=status.getSettings_auto_opt()
                            recdb.recreserv(titlet,chtxtt, btimet, etimet,topt)
                    except Exception, inst:
                        print "error occures in search_keyword_auto_jbk"
                        print str(type(inst))
                        print str(inst)
                else:
                    try:
                        recdb.add_auto_keyword(chtxtt, titlet, btimet, etimet)
                    except Exception, inst:
                        print "error occures in search_keyword"
                        print str(type(inst))
                        print str(inst)
def type_reserve(typetxt,chtxt,title,bt,et,opt):
    btime = bt.strftime("%Y-%m-%d %H:%M:%S")
    etime = et.strftime("%Y-%m-%d %H:%M:%S")
    typetxtnow=typetxt
    typetxtfinal=""
    if typetxt==recdblist.REC_RESERVE:
        typetxtfinal=recdblist.REC_FINAL_RESERVE
    tnow = datetime.datetime.now()
    dtt = bt-tnow
    dt = dtt.days * 24 * 60 * 60 + dtt.seconds
    if (dt < 58 * 60 and dt > 30 * 60):
        bctypet = chdb.chtxtsearch(chtxt)['bctype']
        chdatat = rec10d.rec10db.select_by_bctype_epg_ch(bctypet)
        dt1 = datetime.datetime.strptime(chdatat[0][5], "%Y-%m-%d %H:%M:%S")-datetime.datetime.now()
        dt1 = dt1.days * 24 * 60 * 60 + dt1.seconds
        if dt1 < 60 * 60:
            recdata = epgdb.searchtime2(title, btime, "5", chtxt)
            chtxtn = recdata[0]
            titlen = recdata[1]
            btimen = recdata[2]
            etimen = recdata[3]
            exp = recdata[4]
            longexp = recdata[5]
            category=recdata[6]
            bt = datetime.datetime.strptime(btimen, "%Y-%m-%d %H:%M:%S")
            et = datetime.datetime.strptime(etimen, "%Y-%m-%d %H:%M:%S")
            btimen = bt.strftime("%Y-%m-%d %H:%M:%S")
            etimen = et.strftime("%Y-%m-%d %H:%M:%S")
            if chtxt != "":
                try:
                    recdb.del_reckey(typetxtnow, title, chtxt, btime)
                    recdb.rec_reckey(typetxtfinal, titlen, chtxtn, btimen, etimen, opt)
                    recdb.rec_reclog(titlen, chtxtn, btimen, etimen, opt, exp, longexp, category)
                    auto_rec.add_key(chtxt, titlen,exp+" "+longexp)
                    auto_rec.add_key("ALL", titlen,exp+" "+longexp)
                    recdblist.printutf8(u"追いかけ機能実行中: "+title+" : "+titlen+" "+btimen+" "+etimen)
                except Exception, inst:
                    print "Error happened in Oikake DB"
                    print str(type(inst))
                    print str(inst)
            else:
                recdblist.printutf8(u"追いかけ機能エラー：番組データが見付かりません。")
        else:
            if rec10d.rec10db.select_by_bctype_epg_ch(bctypet)[0][6] != "0":
                rec10d.rec10db.update_status_by_bctype_epg_ch(bctypet, "3")
        sys.exit()
    elif (dt <= 30 * 60 and dt > 20 * 60):
        recdata = epgdb.searchtime2(title, btime, "5", chtxt)
        chtxtn = recdata[0]
        titlen = recdata[1]
        btimen = recdata[2]
        etimen = recdata[3]
        exp = recdata[4]
        longexp = recdata[5]
        category=recdata[6]
        bt = datetime.datetime.strptime(btimen, "%Y-%m-%d %H:%M:%S")
        et = datetime.datetime.strptime(etimen, "%Y-%m-%d %H:%M:%S")
        btimen = bt.strftime("%Y-%m-%d %H:%M:%S")
        etimen = et.strftime("%Y-%m-%d %H:%M:%S")
        if chtxt != "":
            try:
                recdb.del_reckey(typetxtnow, title, chtxt, btime)
                recdb.rec_reckey(typetxtfinal, titlen, chtxtn, btimen, etimen, opt)
                recdb.rec_reclog(titlen, chtxtn, btimen, etimen, opt, exp, longexp, category)
                auto_rec.add_key(chtxt, titlen,exp+" "+longexp)
                auto_rec.add_key("ALL", titlen,exp+" "+longexp)
                recdblist.printutf8(u"追いかけ機能実行中: "+title+" : "+titlen+" "+btimen+" "+etimen)
            except Exception, inst:
                print "Error happened in Oikake DB"
                print type(inst)
                print inst
    elif dt <= 20 * 60:
        try:
            recdb.del_reckey(typetxtnow, title, chtxt, btime)
            recdb.rec_reckey(typetxtfinal, title, chtxt, btime, etime, opt)
        except Exception, inst:
            print type(inst)
            print inst
def type_final(typetxt,chtxt,title,bt,et,opt):
    btime = bt.strftime("%Y-%m-%d %H:%M:%S")
    etime = et.strftime("%Y-%m-%d %H:%M:%S")
    typetxtnow=typetxt
    typetxting=""
    typetxtdecque=""
    if typetxt==recdblist.REC_FINAL_RESERVE:
        typetxting=recdblist.REC_TS_RECORDING
        typetxtdecque=recdblist.REC_TS_DECODE_QUE
    tnow = datetime.datetime.now()
    dtt = bt-tnow
    dt = dtt.days * 24 * 60 * 60 + dtt.seconds
    print dt
    if dt < 6 * 60 and dt > 0:
        newtitle=title
        recdb.del_reckey(typetxtnow, title, chtxt, btime)
        testpath=[os.path.join(recpath,title+".ts.b25")]
        testpath.append(os.path.join(recpath,title+".ts"))
        testpath.append(os.path.join(recpath,title+".avi"))
        testpath.append(os.path.join(recpath,title+".mp4"))
        testpath.append(os.path.join(recpath,title+".log"))
        tcheck=0
        for ti in testpath:
            if os.path.exists(ti):
                tcheck=tcheck+1
        if re.search("N", opt) or tcheck>0:
            iff=""
            try:
                iff=u"("+configreader.getenv("iff")+u")_"
            except:
                iff=""
            newtime=bt
            newtitle=newtitle+u"_"+iff+newtime.strftime("%Y-%m-%dT%H-%M-%S")
        recdb.rec_reckey(typetxting, newtitle, chtxt, btime, etime, opt)
        recdblist.printutf8(u"録画開始 "+newtitle+" "+btime+" "+etime)
        tv2avi.timetv2b25(recpath + "/" + newtitle + ".avi", chtxt, btime, etime, opt)
        recdb.del_reckey(typetxting, newtitle, chtxt, btime)
        if not re.search("R", opt):
            tnow = datetime.datetime.now()
            bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
            et = datetime.datetime.strptime(etime, "%Y-%m-%d %H:%M:%S")
            dt = tnow-bt
            bt = tnow + datetime.timedelta(seconds=600)
            et = et + dt + datetime.timedelta(seconds=600)
            btime = bt.strftime("%Y-%m-%d %H:%M:%S")
            etime = et.strftime("%Y-%m-%d %H:%M:%S")
            recdb.rec_reckey(typetxtdecque, newtitle, chtxt, btime, etime, opt)
        else:
            try:
                shutil.copy(os.path.join(recpath,title+".ts.b25"), os.path.join(movepath,title+".ts.b25"))
            except:
                ""
            recdb.rec_reckey(recdblist.REC_MOVE_END, newtitle, chtxt, btime, etime, opt)
        sys.exit()
def type_keyword(typetxt,chtxt,title,bt,et,opt,deltatime):
    btime = bt.strftime("%Y-%m-%d %H:%M:%S")
    etime = et.strftime("%Y-%m-%d %H:%M:%S")
    typetxtnow=typetxt
    typetxtres=""
    if typetxt==recdblist.REC_KEYWORD:
        typetxtres=recdblist.REC_RESERVE
    tnow = datetime.datetime.now()
    dtt = bt-tnow
    dt = dtt.days * 24 * 60 * 60 + dtt.seconds
    print dt
    if dt < 90 * 60:
        recdata = epgdb.searchtime2(title, btime, deltatime, chtxt)
        if recdata[1] != "":
            chtxtt = recdata[0]
            titlet = recdata[1]
            btimet = recdata[2]
            etimet = recdata[3]
            exp = recdata[4]
            longexp = recdata[5]
            category=recdata[6]
            bt = datetime.datetime.strptime(btimet, "%Y-%m-%d %H:%M:%S")
            et = datetime.datetime.strptime(etimet, "%Y-%m-%d %H:%M:%S")
            btimet = bt.strftime("%Y-%m-%d %H:%M:%S")
            etimet = et.strftime("%Y-%m-%d %H:%M:%S")
            #try:
            recdb.del_reckey(typetxtnow, title, chtxt, btime)
            recdb.rec_reckey(typetxtres, titlet, chtxtt, btimet, etimet, opt)
            recdb.rec_reclog(titlet, chtxtt, btimet, etimet, opt, exp,longexp,category)
            auto_rec.add_key(chtxt, titlet,exp+" "+longexp)
            auto_rec.add_key("ALL", titlet,exp+" "+longexp)
            recdblist.printutf8(u"key "+title+u" : "+titlet+u" "+btimet+u" "+etimet)
            #except Exception, inst:
            #    recdblist.printutf8("Error happened in REC_KEYWORD DB")
            #    recdblist.printutf8(type(inst))
            #    recdblist.printutf8(inst)
        else:
            recdblist.printutf8("nothing match")

def type_keyword_every_day(type,chtxt,title,bt,et,opt,deltatime,deltaday):
    btime = bt.strftime("%Y-%m-%d %H:%M:%S")
    etime = et.strftime("%Y-%m-%d %H:%M:%S")
    tnow = datetime.datetime.now()
    dtt = bt-tnow
    dt = dtt.days * 24 * 60 * 60 + dtt.seconds
    dd = datetime.timedelta(days=int(deltaday))
    if dtt.days < 0:
        recdb.del_reckey(recdblist.REC_KEYWORD_EVERY_SOME_DAYS, title, chtxt, btime)
        bt = bt + dd
        et = et + dd
        btxt = bt.strftime("%Y-%m-%d %H:%M:%S")
        etxt = et.strftime("%Y-%m-%d %H:%M:%S")
        recdb.everyreserv(title, chtxt, btxt, etxt, deltatime, opt, deltaday)
    elif dt < 120 * 60:
        recdb.keyreserv(title, chtxt, btime, etime, deltatime, opt)
        recdb.del_reckey(recdblist.REC_KEYWORD_EVERY_SOME_DAYS, title, chtxt, btime)
        bt = bt + dd
        et = et + dd
        btxt = bt.strftime("%Y-%m-%d %H:%M:%S")
        etxt = et.strftime("%Y-%m-%d %H:%M:%S")
        recdb.everyreserv(title, chtxt, btxt, etxt, deltatime, opt, deltaday)


def type_decode_que(typetxt,chtxt,title,bt,et,opt):
    btime = bt.strftime("%Y-%m-%d %H:%M:%S")
    etime = et.strftime("%Y-%m-%d %H:%M:%S")
    tnow = datetime.datetime.now()
    dtt = bt-tnow
    dt = dtt.days * 24 * 60 * 60 + dtt.seconds
    typetxtnow=typetxt
    typetxting=""
    typetxtmiss=""
    typetxtencque=""
    if typetxt== recdblist.REC_TS_DECODE_QUE:
        typetxting=recdblist.REC_TS_DECODING
        typetxtmiss=recdblist.REC_MISS_DECODE
        typetxtencque=recdblist.REC_ENCODE_QUE
    tnow = datetime.datetime.now()
    dtt = bt-tnow
    dt = dtt.days * 24 * 60 * 60 + dtt.seconds
    if dt < 10 * 60:
        if status.getB25Decoding() < 2:
            pin = recpath + "/" + title
            recdb.del_reckey(typetxtnow, title, chtxt, btime)
            recdb.rec_reckey(typetxting, title, chtxt, btime, etime, opt)
            tv2avi.b252ts(pin, chtxt, btime, etime, opt)
            recdb.del_reckey(typetxting, title, chtxt, btime)
            if not os.access(recpath + "/" + title + ".ts", os.F_OK):
                recdb.del_reckey(typetxting, title, chtxt, btime)
                recdb.rec_reckey(typetxtmiss, title, chtxt, btime, etime, opt)
            else:
                ch=checker.checkB25Decode(recpath + "/" + title + ".ts.b25", recpath + "/" + title + ".ts")
                print ch
                if ch == 1:
                    os.remove(recpath + "/" + title + ".ts.b25")
            bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
            et = datetime.datetime.strptime(etime, "%Y-%m-%d %H:%M:%S")
            dt = et-bt
            if not re.search("D", opt):
                tnow = datetime.datetime.now()
                bt = tnow + datetime.timedelta(seconds=600)
                et = bt + dt
                btime = bt.strftime("%Y-%m-%d %H:%M:%S")
                etime = et.strftime("%Y-%m-%d %H:%M:%S")
                recdb.rec_reckey(typetxtencque, title, chtxt, btime, etime, opt)
            else:
                try:
                    shutil.copy(os.path.join(recpath,title+".ts"), os.path.join(movepath,title+".ts"))
                except Exception, inst:
                    errtxt="Error happened in type_decode_que in timerec.\n"
                    errtxt=errtxt+"move ts error.\n"
                    errtxt=errtxt+str(type(inst))+"\n"
                    errtxt=errtxt+str(inst)
                    recdblist.addlog(os.path.join(recpath,title+".ts"), errtxt, "timerec-move(Decode) error")
                recdb.rec_reckey(recdblist.REC_MOVE_END, title, chtxt, btime, etime, opt)
        else:
            recdb.del_reckey(typetxtnow, title, chtxt, btime)
            bt = bt + datetime.timedelta(seconds=600)
            et = et + datetime.timedelta(seconds=600)
            btime = bt.strftime("%Y-%m-%d %H:%M:%S")
            etime = et.strftime("%Y-%m-%d %H:%M:%S")
            recdb.rec_reckey(typetxtnow, title, chtxt, btime, etime, opt)
    sys.exit()

def type_encode_que(typetxt,chtxt,title,bt,et,opt):
    btime = bt.strftime("%Y-%m-%d %H:%M:%S")
    etime = et.strftime("%Y-%m-%d %H:%M:%S")
    tnow = datetime.datetime.now()
    dtt = bt-tnow
    dt = dtt.days * 24 * 60 * 60 + dtt.seconds
    typetxtnow=typetxt
    typetxting=""
    typetxtfin=""
    if typetxt==recdblist.REC_ENCODE_QUE:
        typetxting=recdblist.REC_ENCODE_LOCAL
        typetxtfin=recdblist.REC_FIN_LOCAL
    if dt < 10 * 60:
        if status.getEncoding() < int(configreader.getenv("enc_max")):
            recdb.del_reckey(typetxtnow, title, chtxt, btime)
            recdb.rec_reckey(typetxting, title, chtxt, btime, etime, opt)
            recdblist.printutf8(opt)
            pin = recpath + "/" + title + ".ts"
            if re.search("d", opt):
                pin = recpath + "/" + title + ".m2v"
                if not os.path.exists(pin) or os.path.getsize(pin)<100*1000:
                    paac2 = recpath + "/" + title + "_2.aac"
                    pmp32 = recpath + "/" + title + "_2.mp3"
                    if not os.path.exists(paac2) and not os.path.exists(pmp32):
                        tv2avi.dualaudio2sep(os.path.join(recpath, title+".ts"),"167")
                time.sleep(3)
            elif re.search("5", opt):
                pin = recpath + "/" + title + ".m2v"
                if not os.path.exists(pin) or os.path.getsize(pin)<100*1000:
                    paac2 = recpath + "/" + title + "_2.aac"
                    pmp32 = recpath + "/" + title + "_2.mp3"
                    if not os.path.exists(paac2) and not os.path.exists(pmp32):
                        tv2avi.pentaaudio2sep(os.path.join(recpath, title+".ts"))
                time.sleep(3)
            pout = recpath + "/" + title + ".mkv"
            recdblist.printutf8(pin)
            tv2mkv.ts2mkv(pin, pout, opt)
            recdb.del_reckey(typetxting, title, chtxt, btime)
            time.sleep(10)
            if re.search("E", opt):
                try:
                    if os.path.exists(os.path.join(recpath,title+".mp4")):
                        shutil.copy(os.path.join(recpath,title+".mp4"), os.path.join(movepath,title+".mp4"))
                    elif os.path.exists(os.path.join(recpath,title+".mkv")):
                        shutil.copy(os.path.join(recpath,title+".mkv"), os.path.join(movepath,title+".mkv"))
                except Exception, inst:
                    errtxt="Error happened in type_encode_que in timerec.\n"
                    errtxt=errtxt+"move mkv/mp4 error.\n"
                    errtxt=errtxt+str(type(inst))+"\n"
                    errtxt=errtxt+str(inst)
                    recdblist.addlog(os.path.join(recpath,title+".ts"), errtxt, "timerec-move(Encode) error")
                recdb.rec_reckey(recdblist.REC_MOVE_END, title, chtxt, btime, etime, opt)
            recdb.rec_reckey(typetxtfin, title, chtxt, btime, etime, opt)
            sys.exit()
        else:
            recdb.del_reckey(typetxtnow, title, chtxt, btime)
            bt = bt + datetime.timedelta(seconds=600)
            et = et + datetime.timedelta(seconds=600)
            btime = bt.strftime("%Y-%m-%d %H:%M:%S")
            etime = et.strftime("%Y-%m-%d %H:%M:%S")
            recdb.rec_reckey(typetxtnow, title, chtxt, btime, etime, opt)
            sys.exit()